//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#property indicator_type1           DRAW_LINE
#property indicator_color1          clrBlack
//+----------------+
#property indicator_buffers         1
#property indicator_plots           1
//+----------------+
enum Enum_TypeInput {
            en_HIGH,           //Use maximum prices
            en_OPEN,           //Use opening prices
            en_CLOSE,          //Use closing prices
            en_LOW             //Use minimum prices
                    };
//+----------------+
input uchar             user01 = 9;             //Exponential average periods
input Enum_TypeInput    user02 = en_CLOSE;      //Data type for calculation
//+----------------+
double   gl_buffer[];
//+------------------------------------------------------------------+
int OnInit()
{
   SetIndexBuffer(0, gl_buffer, INDICATOR_DATA);

   return INIT_SUCCEEDED;
};
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total, const int prev_calculated, const datetime &Time[], const double &Open[], const double &High[], const double &Low[], const double &Close[], const long &TickVolume[], const long &Volume[], const int &Spread[])
{
   double   k = 2. / (1 + user01),
            price = 0;

   for (int c = (prev_calculated > 0 ? prev_calculated - 1 : 0); c < rates_total; c++)
   {
        switch (user02)
        {
            case en_HIGH   :
                price = High[c];
                break;
            case en_OPEN   :
                price = Open[c];
                break;
            case en_CLOSE  :
                price = Close[c];
                break;
            case en_LOW    :
                price = Low[c];
                break;
        }
        gl_buffer[c] = (c ? ((price - gl_buffer[c - 1]) * k) + gl_buffer[c - 1] : price * k);
   }

   return rates_total;
};
//+------------------------------------------------------------------+